<?php $__env->startSection('description'); ?>
    <?php
        $data = metaData('home');
    ?>
    <?php echo e($data->description); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('og:image'); ?>
    <?php echo e(asset($data->image)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('title'); ?>
    <?php echo e($data->title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('main'); ?>

<link rel="stylesheet" href="<?php echo e(asset('css/custom.css')); ?>">

<style>
    @font-face {
    font-family: 'Solaiman Lipi';
    src: url('/fonts/SolaimanLipi.ttf') format('truetype');
    font-weight: normal;
    font-style: normal;
}

body {
    font-family: 'Solaiman Lipi', sans-serif !important;
}

p, h1, h2, h3 {
    font-family: 'Solaiman Lipi', sans-serif;
}

</style>

    <section class="hero-section-3">
       <div class="container">
            <div class="tw-flex tw-justify-center tw-items-center tw-relative tw-z-50">
                <div class="tw-max-w-3xl tw-text-white tw-text-center">


                    
<?php
    // This block defines the $form_action variable based on session data.
    // It needs to be present in the Blade file where the search form is used.
    $form_action = route('website.job');
    if (session('header_search_role') == 'candidate') {
        $form_action = route('website.candidate');
    } elseif (session('header_search_role') == 'company') {
        $form_action = route('website.company');
    }
?>


<form action="<?php echo e($form_action); ?>" method="GET" id="hero-search-form"
    class="tw-max-w-xl tw-mx-auto"> 
    <div class="search-box tw-flex tw-rounded-lg tw-overflow-hidden mb-5"> 
       
        <div class="tw-flex tw-flex-grow tw-items-center tw-bg-white tw-px-4 tw-rounded-r-lg">
            <svg class="searcbox-searchicon tw-text-gray-500 tw-me-2" width="24" height="24" viewBox="0 0 24 24"
                fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M11 19C15.4183 19 19 15.4183 19 11C19 6.58172 15.4183 3 11 3C6.58172 3 3 6.58172 3 11C3 15.4183 6.58172 19 11 19Z"
                    stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                    stroke-linejoin="round" />
                <path d="M21 20.9999L16.65 16.6499" stroke="currentColor" stroke-width="1.5"
                    stroke-linecap="round" stroke-linejoin="round" />
            </svg>
            <input name="keyword" class="search-input tw-w-full tw-py-3 tw-border-none focus:tw-ring-0 pointer-events-auto" type="text"
                placeholder="<?php echo e(__('job_title_keyword')); ?>" value="<?php echo e(request('keyword')); ?>"
                id="hero_global_search"> 
        </div>
        
    </div>
    <span id="hero_autocomplete_job_results"></span> 
</form>



<script>
    function changeHeroSearchSelections() {
        var job_search_url = "<?php echo e(route('website.job')); ?>";
        var candidate_search_url = "<?php echo e(route('website.candidate')); ?>";
        var company_search_url = "<?php echo e(route('website.company')); ?>";
        var search_selection = $("#heroHeaderSearchs").val(); // Use the new ID

        if (search_selection == 'job') {
            $("#hero-search-form").attr('action', job_search_url); // Use the new form ID
        } else if (search_selection == 'candidate') {
            $("#hero-search-form").attr('action', candidate_search_url); // Use the new form ID
        } else if (search_selection == 'company') {
            $("#hero-search-form").attr('action', company_search_url); // Use the new form ID
        }
    }
</script>

                    <h1 class="tw-text-white">কিউ জবস - আপনার পছন্দমতো চাকরির জন্য সেরা প্ল্যাটফর্ম!</h1>
                    <p>আপনার স্বপ্নের চাকরি পেতে এখনই আবেদন করুন।</p>
                    <form action="<?php echo e(route('website.job')); ?>" method="GET" id="job_search_form">
                        <div class=" d-flex flex-column flex-md-row bg-gray-10 input-transparent rt-mb-24">
                            <!--<div class="flex-grow-1 fromGroup has-icon">-->
                            <!--    <input id="index_search" name="keyword" type="text"-->
                            <!--        placeholder="<?php echo e(__('job_title_keyword')); ?>" value="<?php echo e(request('keyword')); ?>"-->
                            <!--        autocomplete="off" class="text-gray-900">-->
                            <!--    <div class="icon-badge">-->
                            <!--        <?php if (isset($component)) { $__componentOriginalaff82f5e25571a3aa5db317d7fd41a9a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaff82f5e25571a3aa5db317d7fd41a9a = $attributes; } ?>
<?php $component = App\View\Components\Svg\SearchIcon::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('svg.search-icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Svg\SearchIcon::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaff82f5e25571a3aa5db317d7fd41a9a)): ?>
<?php $attributes = $__attributesOriginalaff82f5e25571a3aa5db317d7fd41a9a; ?>
<?php unset($__attributesOriginalaff82f5e25571a3aa5db317d7fd41a9a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaff82f5e25571a3aa5db317d7fd41a9a)): ?>
<?php $component = $__componentOriginalaff82f5e25571a3aa5db317d7fd41a9a; ?>
<?php unset($__componentOriginalaff82f5e25571a3aa5db317d7fd41a9a); ?>
<?php endif; ?>-->
                            <!--    </div>-->
                            <!--    <span id="autocomplete_index_job_results"></span>-->
                            <!--</div>-->
                            
                             <div class="flex-grow-1 fromGroup has-icon">
                               <select
                                    class=" select2-taggable select2-search form-control <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="category_id">
                                    <?php $__currentLoopData = $jobCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e(old('category_id') == $category->id ? 'selected' : ''); ?>

                                            value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        
                            <input type="hidden" name="lat" id="lat" value="">
                            <input type="hidden" name="long" id="long" value="">
                            <?php
                                $oldLocation = request('location');
                                $map = $setting->default_map;
                            ?>

                            <?php if($map == 'google-map'): ?>
                                <div class="flex-grow-1 fromGroup has-icon banner-select no-border">








                                </div>
                            <?php else: ?>
                                <div class="flex-grow-1 fromGroup has-icon banner-select no-border">

                                    <select
                                        class=" select2-taggable select2-search form-control <?php $__errorArgs = ['district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="district_id"
                                        id="district_id">
                                        <option value="">জেলা</option>
                                        <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(old('district_id') == $district->id ? 'selected' : ''); ?>

                                                    value="<?php echo e($district->id); ?>"><?php echo e($district->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>









                                </div>
                                <div class="flex-grow-1 fromGroup has-icon banner-select no-border">

                                    <select
                                        class="select2-taggable select2-search form-control <?php $__errorArgs = ['upazila_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="upazila_id"
                                        id="upazila_id">
                                        <option value="">উপজেলা</option>
                                    </select>









                                </div>
                            <?php endif; ?>
                            <div class="flex-grow-0">
                                <button type="submit"
                                    class="btn btn-primary d-block d-md-inline-block "><?php echo e(__('find_job_now')); ?></button>
                            </div>
                        </div>
                    </form>
                    <?php if($top_categories->count()): ?>
                        <div class="f-size-14 banner-quciks-links" data-aos="" data-aos-duration="1000"
                            data-aos-delay="500">
                            <span class="!tw-text-gray-300"><?php echo e(__('suggestion')); ?>: </span>
                            <?php $__currentLoopData = $top_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item->slug): ?>
                                    <a class="!tw-text-white tw-underline"
                                        href="<?php echo e(route('website.job.category.slug', ['category' => $item->slug])); ?>">>
                                        <?php echo e($item->name); ?> <?php echo e(!$loop->last ? ',' : ''); ?></a>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
    <!-- google adsense area -->
    <?php if(advertisement_status('home_page_ad')): ?>
        <?php if(advertisementCode('home_page_thin_ad_after_counter_section')): ?>
            <div class="container my-4">
                <?php echo advertisementCode('home_page_thin_ad_after_counter_section'); ?>

            </div>
        <?php endif; ?>
    <?php endif; ?>
    <!-- google adsense area end -->
    
    <!-- category section -->
    <section class="tw-bg-primary-50 md:tw-py-20 tw-py-12">
        <div class="container">
            <div>
                <h2>টপ ক্যাটাগরি</h2>
            </div>
            <div class="tw-mt-8 tw-relative tw-z-50">
                <div class="tw-grid tw-grid-cols-1  md:tw-grid-cols-2 lg:tw-grid-cols-4 tw-gap-6">
                    <?php
                        $popular_categories = $popular_categories->toArray();
                        ksort($popular_categories);
                    ?>
                    <?php $__currentLoopData = $popular_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(isset($category['slug'])): ?>
                            <a href="<?php echo e(route('website.job.category.slug', $category['slug'])); ?>"
                                class="!tw-bg-white tw-transition-all tw-duration-300 hover:-tw-translate-y-[2px] tw-shadow-md tw-rounded-md tw-px-4 tw-py-2.5 tw-flex tw-gap-4 tw-items-center">
                                <span class="tw-text-2xl">
                                    <i class="<?php echo e($category['icon']); ?>"></i>
                                </span>
                                <div class=" tw-flex-1">
                                    <h4 class="tw-mb-0 tw-text-lg"><?php echo e($category['name']); ?></h4>
                                    <p class="tw-mb-0 tw-text-sm"><?php echo e($category['jobs_count']); ?> <?php echo e(__('open_positions')); ?></p>
                                </div>
                            </a>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

            </div>
        </div>
    </section>
    
    <!-- top companies -->
<?php if($top_companies && count($top_companies) > 0): ?>
    <?php if(!auth('user')->check() || (auth('user')->check() && authUser()->role == 'candidate')): ?>
        <section class="md:tw-py-20 tw-py-12">
            <div class="container">
                <div class="row md:tw-pb-12 tw-pb-8">
                    <div class="col-12">
                        <div class="d-flex flex-wrap">
                            <div class="flex-grow-1">
                                <h4><?php echo e(__('টপ')); ?> <span
                                        class="text-primary-500 has-title-shape"><?php echo e(__('কোম্পানি')); ?>

                                        <img src="<?php echo e(asset('frontend')); ?>/assets/images/all-img/title-shape.png"
                                            alt="">
                                    </span></h4>
                            </div>
                            <a href="<?php echo e(route('website.company')); ?>" class="flex-grow-0 rt-pt-md-10">
                                <button class="btn btn-outline-primary">
                                    <span class="button-content-wrapper ">
                                        <span class="button-icon align-icon-right">
                                            <i class="ph-arrow-right"></i>
                                        </span>
                                        <span>
                                            <?php echo e(__('view_all')); ?>

                                        </span>
                                    </span>
                                </button>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php $__currentLoopData = $top_companies->slice(0, 4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <!-- Limit to 4 companies -->
                        <div class="col-xl-3 col-md-4 fade-in-bottom  condition_class rt-mb-24 tw-self-stretch">
                            <a href="<?php echo e(route('website.employe.details', $company->user->username)); ?>"
                                class="card jobcardStyle1 tw-h-full hover:!-tw-translate-y-1">
                                <div class="tw-p-6 tw-flex tw-flex-col tw-gap-1.5">
                                    <div class="tw-w-14 tw-h-14">
                                        <img class="tw-w-full tw-h-full tw-object-cover"
                                            src="<?php echo e($company->logo_url); ?>" alt="" draggable="false">
                                    </div>
                                    <div>
                                        <div class="">
                                            <span
                                                class="tw-text-[#191F33] tw-text-base tw-font-medium"><?php echo e($company->user->name); ?></span>
                                        </div>
                                        <span
                                            class="tw-inline-flex tw-text-sm tw-gap-1 tw-items-center text-gray-400 ">
                                            <i class="ph-map-pin"></i>
                                            <?php echo e($company->country); ?>

                                        </span>
                                    </div>
                                    <div class="tw-flex tw-flex-wrap tw-gap-1.5">
                                        <span
                                            class="tw-px-2 tw-py-0.5 tw-inline-block tw-text-xs tw-font-medium tw-text-[#474C54] tw-rounded-[52px] tw-bg-primary-50 ll-primary-border">
                                            <?php echo e($company?->industry?->name ?? ''); ?>

                                        </span>
                                        <span
                                            class="tw-px-2 tw-py-0.5 tw-inline-block tw-text-xs tw-font-medium tw-text-[#474C54] tw-rounded-[52px] tw-bg-primary-50 ll-primary-border"><?php echo e($company->jobs_count); ?>

                                            <?php echo e(__('open_position')); ?></span>
                                    </div>
                                </div>
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
<?php endif; ?>


    <!-- Top jobs card -->
    <section class="tw-bg-primary-50 md:tw-py-20 tw-py-12">
        <div class="container">
            <div class="row md:tw-pb-12 tw-pb-8">
                <div class="col-12">
                    <div class="tw-flex tw-gap-3 tw-items-center tw-flex-wrap">
                        <div class="flex-grow-1">
                            <h4 class="tw-mb-0">
                                <?php echo e(__('টপ')); ?>

                                <span class="text-primary-500 has-title-shape"><?php echo e(__('ফিচারড জব')); ?>

                                    <img src="<?php echo e(asset('frontend')); ?>/assets/images/all-img/title-shape.png"
                                        alt="">
                                </span>
                            </h4>
                        </div>
                        <a href="<?php echo e(route('website.job')); ?>" class="flex-grow-0 rt-pt-md-10">
                            <button class="btn btn-outline-primary !tw-border-primary-500">
                                <span class="button-content-wrapper ">
                                    <span class="button-icon align-icon-right">
                                        <i class="ph-arrow-right"></i>
                                    </span>
                                    <span>
                                        <?php echo e(__('view_all')); ?>

                                    </span>
                                </span>
                            </button>
                        </a>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php if($featured_jobs && count($featured_jobs) > 0): ?>
                    <?php $__currentLoopData = $featured_jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-md-4 fade-in-bottom  condition_class rt-mb-24 tw-self-stretch">
                            <a href="<?php echo e(route('website.job.details', $job->slug)); ?>"
                                class="tw-h-full card tw-card tw-block jobcardStyle1 tw-border-gray-200 hover:!-tw-translate-y-1 hover:tw-bg-primary-50 tw-bg-gray-50"
                                tabindex="0">
                                <div class="tw-p-6 tw-flex tw-gap-3 tw-flex-col tw-justify-between tw-h-full">
                                    <div>
                                        <div class="tw-mb-1.5">
                                            <span class="tw-text-[#18191C] tw-text-lg tw-font-medium">
                                                <?php echo e($job->title); ?>

                                            </span>
                                        </div>
                                        <div class="tw-flex tw-flex-wrap tw-gap-2 tw-items-center tw-mb-1.5">
                                            <span
                                                class="tw-text-[#0BA02C] tw-text-[12px] tw-leading-[12px] tw-font-semibold tw-bg-[#E7F6EA] tw-px-2 tw-py-1 tw-rounded-[3px]">
                                                <?php echo e($job->job_type ? $job->job_type->name : ''); ?>

                                            </span>
                                        </div>
                                        <!--<div>-->
                                        <!--    <span class="tw-text-sm tw-text-[#767F8C]">-->
                                        <!--        <?php if($job->salary_mode == 'range'): ?>-->
                                        <!--            <?php echo e(currencyAmountShort($job->min_salary)); ?> --->
                                        <!--            <?php echo e(currencyAmountShort($job->max_salary)); ?>-->
                                        <!--            <?php echo e(currentCurrencyCode()); ?>-->
                                        <!--        <?php else: ?>-->
                                        <!--            <?php echo e($job->custom_salary); ?>-->
                                        <!--        <?php endif; ?>-->
                                        <!--    </span>-->
                                        <!--</div>-->
                                        <div>
                                            <span class="tw-text-sm tw-text-[#767F8C] salary-section">
                                                <?php if($job->salary_mode == 'range'): ?>
                                                    <?php echo e(currencyAmountShort($job->min_salary)); ?> -
                                                    <?php echo e(currencyAmountShort($job->max_salary)); ?>

                                                    <?php echo e(currentCurrencyCode()); ?>

                                                <?php else: ?>
                                                    <?php echo e($job->custom_salary); ?>

                                                <?php endif; ?>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="tw-flex tw-items-center tw-gap-2">
                                        <span>
                                            <div class="tw-w-[56px] tw-h-[56px]">
                                                <img class="tw-rounded-lg tw-w-[56px] tw-h-[56px]"
                                                    src="<?php echo e($job?->company?->logo_url); ?>" alt=""
                                                    draggable="false">

                                            </div>
                                        </span>
                                        <div class="iconbox-content">
                                            <div class="tw-mb-1 tw-inline-flex">
                                                <span
                                                    class="tw-text-base tw-font-medium tw-text-[#18191C]"><?php echo e($job->company->user->name ?? " "); ?></span>
                                            </div>
                                            <span class="tw-flex tw-items-center tw-gap-1">
                                                <i class="ph-map-pin"></i>
                                                <?php
                                                    $district = DB::table('districts')->where('id', $job->district_id)->value('name');
                                                    $upazilas = DB::table('upazilas')->where('id', $job->upazila_id)->value('name');
                    
                                                ?>
                                                <span class="tw-location"><?php echo e($district); ?>, <?php echo e($upazilas); ?></span>
                                            </span>
                                        </div>
                                    </div>
                                    <div>
                                        <button
                                            class="btn hover:tw-text-white hover:tw-bg-primary-700 tw-px-2.5 tw-py-1 tw-text-white tw-bg-primary-500"><?php echo e(__('apply_now')); ?></button>
                                    </div>
                                </div>
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
        </div>
    </section>
    
    
 <!-- Latest Blog Post -->   
<section class="testimonials-area bg-light py-5">
    <div class="container">
                <div class="col-12 mt-5">
                    <div class="tw-flex tw-gap-3 tw-items-center tw-flex-wrap">
                        <div class="flex-grow-1">
                            <h4 class="tw-mb-0">
                                <?php echo e(__('টপ')); ?>

                                <span class="text-primary-500 has-title-shape"><?php echo e(__('ব্লগ')); ?>

                                    <img src="<?php echo e(asset('frontend')); ?>/assets/images/all-img/title-shape.png"
                                        alt="">
                                </span>
                            </h4>
                        </div>
                        <a href="https://qjobsbd.com/posts" class="flex-grow-0 rt-pt-md-10">
                            <button class="btn btn-outline-primary !tw-border-primary-500">
                                <span class="button-content-wrapper ">
                                    <span class="button-icon align-icon-right">
                                        <i class="ph-arrow-right"></i>
                                    </span>
                                    <span>
                                        <?php echo e(__('view_all')); ?>

                                    </span>
                                </span>
                            </button>
                        </a>
                    </div>
                </div>

        <div class="row">
            <?php $__currentLoopData = $recent_posts->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12 col-sm-6 col-lg-3 mb-4">
                    <div class="card h-100 shadow-sm">
                        <a href="<?php echo e(route('website.post', $post->slug)); ?>" class="text-decoration-none text-dark">
                            
                            <img src="<?php echo e(url($post->image)); ?>" alt="<?php echo e($post->title); ?>" class="card-img-top" style="height: 200px; object-fit: cover;">

                            
                            <div class="card-body">
                                <p class="card-text text-muted small mb-1">
                                    <?php echo e(\Carbon\Carbon::parse($post->created_at)->format('M d, Y')); ?>

                                </p>
                                <h5 class="card-title fw-bold mb-1">
                                    <?php echo e($post->title); ?>

                                </h5>
                                <p class="card-text text-secondary small">
                                    <?php echo e(Str::limit($post->short_description, 80)); ?>

                                </p>
                            </div>
                        </a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>


<!-- Sofol bektider golpo -->

<section class="testimoinals-area tw-bg-[#F1F2F4]">
    <div class="rt-spacer-100 rt-spacer-md-50"></div>
    <div class="container">
        <div class="row">
            
            <div class="col-12 mt-5">
                    <div class="tw-flex tw-gap-3 tw-items-center tw-flex-wrap">
                        <div class="flex-grow-1">
                            <h4 class="tw-mb-0">
                                <?php echo e(__('সফল')); ?>

                                <span class="text-primary-500 has-title-shape"><?php echo e(__('ব্যাক্তিদের গল্প')); ?>

                                    <img src="<?php echo e(asset('frontend')); ?>/assets/images/all-img/title-shape.png"
                                        alt="">
                                </span>
                            </h4>
                        </div>
                        
                    </div>
                </div>
                
                
        </div>
        <div class="rt-spacer-40 rt-spacer-md-20"></div>
        <div class="row">
            <div class="col-12 position-parent">
                <div class="slick-btn-gorup">
                    <button class="btn slickprev2">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                             xmlns="http://www.w3.org/2000/svg">
                            <path d="M19 12H5" stroke="#1D4ED8" stroke-width="1.5"
                                  stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M12 5L5 12L12 19" stroke="#1D4ED8" stroke-width="1.5"
                                  stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                    </button>
                    <button class="btn slicknext2">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                             xmlns="http://www.w3.org/2000/svg">
                            <path d="M5 12H19" stroke="#1D4ED8" stroke-width="1.5"
                                  stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M12 5L19 12L12 19" stroke="#1D4ED8" stroke-width="1.5"
                                  stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                    </button>
                </div>

                <div class="testimonail_active slick-bullet deafult_style_dot">
                    <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="single-item">
                            <div class="testimonals-box">
                                <div class="rt-mb-12">
                                    <?php for($i = 0; $i < $testimonial->stars; $i++): ?>
                                        <svg width="28" height="28" viewBox="0 0 28 28" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M12.9241 4.51321C13.3643 3.62141 14.636 3.62141 15.0762 4.51321L17.3262 9.07149C17.5009 9.42531 17.8383 9.67066 18.2287 9.72773L23.2623 10.4635C24.2462 10.6073 24.6383 11.8167 23.926 12.5105L20.2856 16.0562C20.0026 16.3319 19.8734 16.7292 19.9402 17.1187L20.7991 22.1264C20.9672 23.1068 19.9382 23.8543 19.0578 23.3913L14.5587 21.0253C14.209 20.8414 13.7913 20.8414 13.4416 21.0253L8.94252 23.3913C8.06217 23.8543 7.03311 23.1068 7.20125 22.1264L8.06013 17.1187C8.12693 16.7292 7.99773 16.3319 7.71468 16.0562L4.07431 12.5105C3.362 11.8167 3.75414 10.6073 4.73804 10.4635L9.7716 9.72773C10.162 9.67066 10.4995 9.42531 10.6741 9.07149L12.9241 4.51321Z"
                                                fill="#FFAA00" />
                                        </svg>
                                    <?php endfor; ?>
                                </div>
                                <div class="text-gray-600 body-font-3">
                                    <?php echo e(Str::words($testimonial->description, 25, '...')); ?>

                                </div>

                                <div class="rt-single-icon-box">
                                    <div class="icon-thumb rt-mr-12">
                                        <div class="userimage">
                                            <img src="<?php echo e(asset($testimonial->image)); ?>" alt="Person"
                                                 draggable="false">
                                        </div>
                                    </div>
                                    <div class="iconbox-content">
                                        <div class="body-font-3"><?php echo e($testimonial->name); ?></div>
                                        <div class="body-font-4 text-gray-400"><?php echo e($testimonial->position); ?></div>
                                    </div>
                                    <div class="iconbox-extra">
                                        <svg width="36" height="36" viewBox="0 0 36 36" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                  d="M16 28C16 30.1217 15.1571 32.1566 13.6569 33.6569C12.1566 35.1571 10.1217 36 8 36C5.87827 36 3.84344 35.1571 2.34315 33.6569C0.842854 32.1566 0 30.1217 0 28C0 23.58 8 0 8 0H12L8 20C10.1217 20 12.1566 20.8429 13.6569 22.3431C15.1571 23.8434 16 25.8783 16 28ZM36 28C36 30.1217 35.1571 32.1566 33.6569 33.6569C32.1566 35.1571 30.1217 36 28 36C25.8783 36 23.8434 35.1571 22.3431 33.6569C20.8429 32.1566 20 30.1217 20 28C20 23.58 28 0 28 0H32L28 20C30.1217 20 32.1566 20.8429 33.6569 22.3431C35.1571 23.8434 36 25.8783 36 28Z"
                                                  fill="#DADDE6" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="rt-spacer-100 rt-spacer-md-50"></div>
</section>


<!-- Tutorial Videos Section -->
<section class="md:tw-py-20 tw-py-12">
    <div class="container">
        <div class="row md:tw-pb-12 tw-pb-8">
            <div class="col-12">
                <div class="d-flex flex-wrap">
                    <div class="flex-grow-1">
                        <h4>আমাদের ভিডিওগুলো<span
                                class="text-primary-500 has-title-shape"> দেখুন
                                <img src="<?php echo e(asset('frontend')); ?>/assets/images/all-img/title-shape.png"
                                    alt="">
                            </span></h4>
                        <h6>কিভাবে CV তৈরি করবেন তা জানতে আমাদের ভিডিও গুলো দেখুন</h6>    
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
       <!-- Video 1 -->
            <div class="col-xl-3 col-md-6 tw-mb-6">
                
                <div class="tw-rounded-lg tw-overflow-hidden tw-border tw-border-blue-300 tw-shadow-md tw-p-2 tw-bg-blue">
                  <iframe width="100%" height="200" src="https://www.youtube.com/embed/x6M8JC0S-xc?si=laAV9iwE-T8t19VS"
                    title="YouTube video player" frameborder="0"
                     allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                      allowfullscreen></iframe>
                 </div>
            </div>
        </div>
    </div>
</section>


    <style>
        /* Floating WhatsApp Button Style */
        .whatsapp-button {
            position: fixed;
            bottom: 90px;
            right: 26px;
            width: 60px;
            height: 60px;
            background-color: #25D366;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            cursor: pointer;
            z-index: 1000;
            transition: transform 0.3s ease;
        }

        .whatsapp-button:hover {
            transform: scale(1.1);
        }

        .whatsapp-button img {
            width: 35px;
            height: 35px;
        }
    </style>
    <!-- Floating WhatsApp Button -->
    <div class="whatsapp-button" onclick="openWhatsApp()">
        <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp">
    </div>

    <script>
        function openWhatsApp() {
            // Replace PHONE_NUMBER with your WhatsApp number (including country code).
            const phoneNumber = "YOUR_PHONE_NUMBER";
            const message = "Hello! I have a query about Qjobs."; // Default message (optional)
            window.open(`https://wa.me/${+8801604815581}?text=${encodeURIComponent(message)}`, '_blank');
        }
    </script>
    
    <!-- Job Post profile -->
    <section class="md:tw-py-20  !tw-border-t !tw-border-b !tw-border-primary-100">
        <div class="container">
            <div class="row tw-items-center">
                <div class="col-lg-12">
                    <div class="">
                        <h2 class="">চাকরি পোস্ট করুন</h2>
                        <p class=""><?php echo e(__('work_profile_description')); ?></p>
                        <div class="">
                            <a href="<?php echo e(route('register')); ?>" class="btn btn-primary">Create Job</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    
    <!-- Candidate profile Create -->
    <section class="mt-5 md:tw-py-20  !tw-border-t !tw-border-b !tw-border-primary-100">
        <div class="container">
            <div class="row tw-items-center">
                <div class="col-lg-12">
                    <div class="">
                        <h2 class=""><?php echo e(__('create_your_personal_account_profile')); ?></h2>
                        <p class=""><?php echo e(__('work_profile_description')); ?></p>
                        <div class="">
                            <a href="<?php echo e(route('register')); ?>" class="btn btn-primary">Create CV</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<!-- About Us -->
    <section class="md:tw-py-20 tw-py-12 !tw-border-t !tw-border-b !tw-border-primary-100">
    <div class="container">
        <div class="row tw-items-center">
            <!-- Image Section -->
            <div class="col-lg-6">
                <img class="tw-rounded-lg" src="<?php echo e(asset('frontend')); ?>/assets/images/all-img/tramk.jpg" alt="About Us">
            </div>
            <!-- Text Section -->
            <div class="col-lg-6">
                <div class="lg:tw-ps-12 tw-pt-6 lg:tw-pt-0">
                    <h5 class="tw-text-primary-500 tw-mb-4"><?php echo e(__('about_us')); ?></h5>
                    <h2 class="">QJobs-এ স্বাগতম, যেখানে সুযোগ মেলে!</h2>
                    <p class="">QJobs-এ, আমরা চাকরিপ্রার্থী এবং নিয়োগকর্তাদের মধ্যে ব্যবধান দূর করতে, ক্যারিয়ার বৃদ্ধি এবং ব্যবসায়িক সাফল্যের জন্য একটি গতিশীল প্ল্যাটফর্ম তৈরি করতে নিবেদিত। আপনি আপনার স্বপ্নের চাকরি খুঁজছেন এমন একজন উচ্চাকাঙ্ক্ষী পেশাদারই হোন বা নিখুঁত প্রার্থীর সন্ধানে ব্যবসায়িক হোন না কেন, কিউজবস হল আপনার বিশ্বস্ত অংশীদার যা ক্রমবর্ধমান চাকরির বাজারে নেভিগেট করার জন্য।</p>
                    <div class="">
                        <a href="https://qjobsbd.com/aboutus" class="btn btn-primary"><?php echo e(__('learn_more')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


    <!-- working process section -->
    <!--<section class="working-process tw-bg-white">-->
    <!--    <div class="rt-spacer-100 rt-spacer-md-50"></div>-->
    <!--    <div class="container">-->
    <!--        <div class="row">-->
    <!--            <div class="col-12 text-center text-h4 ft-wt-5">-->
    <!--                <span class="text-primary-500 has-title-shape"><?php echo e(config('app.name')); ?>-->
    <!--                    <img src="<?php echo e(asset('frontend')); ?>/assets/images/all-img/title-shape.png" alt="">-->
    <!--                </span>-->
    <!--                <label for=""><?php echo e(__('working_process')); ?></label>-->
    <!--            </div>-->
    <!--        </div>-->
    <!--        <div class="rt-spacer-50"></div>-->
    <!--        <div class="row">-->
    <!--            <div class="col-lg-3 col-sm-6 rt-mb-24 position-relative">-->
    <!--                <div class="has-arrow first">-->
    <!--                    <img src="<?php echo e(asset('frontend')); ?>/assets/images/all-img/arrow-1.png" alt=""-->
    <!--                        draggable="false">-->
    <!--                </div>-->
    <!--                <div class="rt-single-icon-box hover:!tw-bg-primary-50 working-progress icon-center">-->
    <!--                    <div class="icon-thumb rt-mb-24">-->
    <!--                        <div class="icon-72">-->
    <!--                            <i class="ph-user-plus"></i>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                    <div class="iconbox-content">-->
    <!--                        <div class="body-font-2 rt-mb-12"><?php echo e(__('explore_opportunities')); ?></div>-->
    <!--                        <div class="body-font-4 text-gray-400">-->
    <!--                            <?php echo e(__('browse_through_a_diverse_range_of_job_listings_tailored_to_your_interests_and_expertise')); ?>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--            <div class="col-lg-3 rt-mb-24 col-sm-6 position-relative">-->
    <!--                <div class="has-arrow middle">-->
    <!--                    <img src="<?php echo e(asset('frontend')); ?>/assets/images/all-img/arrow-2.png" alt=""-->
    <!--                        draggable="false">-->
    <!--                </div>-->
    <!--                <div class="rt-single-icon-box hover:!tw-bg-primary-50 working-progress icon-center">-->
    <!--                    <div class="icon-thumb rt-mb-24">-->
    <!--                        <div class="icon-72">-->
    <!--                            <i class="ph-cloud-arrow-up"></i>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                    <div class="iconbox-content">-->
    <!--                        <div class="body-font-2 rt-mb-12"><?php echo e(__('create_your_profile')); ?></div>-->
    <!--                        <div class="body-font-4 text-gray-400">-->
    <!--                            <?php echo e(__('build_a_standout_profile_highlighting_your_skills_experience_and_qualifications')); ?>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--            <div class="col-lg-3 rt-mb-24 col-sm-6 position-relative">-->
    <!--                <div class="has-arrow last">-->
    <!--                    <img src="<?php echo e(asset('frontend')); ?>/assets/images/all-img/arrow-1.png" alt=""-->
    <!--                        draggable="false">-->
    <!--                </div>-->
    <!--                <div class="rt-single-icon-box hover:!tw-bg-primary-50 working-progress icon-center">-->
    <!--                    <div class="icon-thumb rt-mb-24">-->
    <!--                        <div class="icon-72">-->
    <!--                            <i class="ph-magnifying-glass-plus"></i>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                    <div class="iconbox-content">-->
    <!--                        <div class="body-font-2 rt-mb-12"><?php echo e(__('apply_with_ease')); ?></div>-->
    <!--                        <div class="body-font-4 text-gray-400">-->
    <!--                            <?php echo e(__('effortlessly_apply_to_jobs_that_match_your_preferences_with_just_a_few_clicks')); ?>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--            <div class="col-lg-3 rt-mb-24 col-sm-6">-->
    <!--                <div class="rt-single-icon-box hover:!tw-bg-primary-50 working-progress icon-center">-->
    <!--                    <div class="icon-thumb rt-mb-24">-->
    <!--                        <div class="icon-72">-->
    <!--                            <i class="ph-circle-wavy-check"></i>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                    <div class="iconbox-content">-->
    <!--                        <div class="body-font-2 rt-mb-12"><?php echo e(__('track_your_progress')); ?></div>-->
    <!--                        <div class="body-font-4 text-gray-400">-->
    <!--                            <?php echo e(__('stay_informed_on_your_applications_and_manage_your_job_seeking_journey_effectively')); ?>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--    <div class="rt-spacer-100 rt-spacer-md-50"></div>-->
    <!--</section>-->
    <!-- google adsense area -->
    <?php if(advertisement_status('home_page_ad')): ?>
        <?php if(advertisementCode('home_page_fat_ad_after_workingprocess_section')): ?>
            <div class="container my-4">
                <?php echo advertisementCode('home_page_fat_ad_after_workingprocess_section'); ?>

            </div>
        <?php endif; ?>
    <?php endif; ?>
    <!-- google adsense area end -->

    <!-- google adsense area -->
    <?php if(advertisement_status('home_page_ad')): ?>
        <?php if(advertisementCode('home_page_fat_ad_after_featuredjob_section')): ?>
            <div class="container my-4">
                <?php echo advertisementCode('home_page_fat_ad_after_featuredjob_section'); ?>

            </div>
        <?php endif; ?>
    <?php endif; ?>
    <!-- google adsense area end -->

    































    <!-- google adsense area -->
    <?php if(advertisement_status('home_page_ad')): ?>
        <?php if(advertisementCode('home_page_fat_ad_after_client_section')): ?>
            <div class="container my-4">
                <?php echo advertisementCode('home_page_fat_ad_after_client_section'); ?>

            </div>
        <?php endif; ?>
    <?php endif; ?>
    <!-- google adsense area end -->
    <!-- newsletter -->
    <!--<section class="section-box tw-mb-8">-->
    <!--    <div class="container">-->
    <!--        <div class="tw-bg-primary-500 tw-p-8 tw-rounded-xl">-->
    <!--            <div class="row align-items-center">-->
    <!--                <div class="tw-relative tw-min-h-[400px] col-xl-3 col-12 text-center d-none d-xl-block">-->
    <!--                    <div class="tw-flex tw-gap-3 tw-items-start tw-flex-wrap">-->
    <!--                        <img class="tw-w-1/2 tw-rounded tw-shadow-sm animation-float-bottom tw-self-center"-->
    <!--                            src="<?php echo e(asset('frontend/assets/images/image-01.jpeg')); ?>" alt="">-->
    <!--                        <img class="tw-w-2/5 tw-rounded tw-shadow-sm animation-float-right tw-self-center"-->
    <!--                            src="<?php echo e(asset('frontend/assets/images/image-02.jpeg')); ?>" alt="">-->
    <!--                        <img class="tw-w-1/2 tw-rounded tw-shadow-sm animation-float-top tw-self-center"-->
    <!--                            src="<?php echo e(asset('frontend/assets/images/image-03.jpeg')); ?>" alt="">-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--                <div class="col-lg-12 col-xl-6 col-12 md:tw-px-10">-->
    <!--                    <h2 class="tw-text-white tw-font-bold tw-mb-8 text-center md:tw-text-4xl tw-text-2xl"> <?php echo __('updates_regularly'); ?>-->
    <!--                    </h2>-->
    <!--                    <div class="box-form-newsletter mt-40">-->
    <!--                        <form action="<?php echo e(route('newsletter.subscribe')); ?>" method="POST" class="tw-gap-2 tw-flex tw-flex-col sm:tw-flex-row">-->
    <!--                            <?php echo csrf_field(); ?>-->
    <!--                            <input required class="input-newsletter" type="email" value="" name="email"-->
    <!--                                placeholder="<?php echo e(__('enter_email_here')); ?>">-->
    <!--                            <button type="submit"-->
    <!--                                class="tw-border-0 tw-min-h-[48px] tw-rounded tw-px-3 tw-font-medium tw-bg-orange-400 !tw-text-white"><?php echo e(__('subscribe')); ?></button>-->
    <!--                        </form>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--                <div class="tw-relative tw-h-full col-xl-3 col-12 text-center d-none d-xl-block">-->
    <!--                    <div class="tw-flex tw-gap-3 tw-items-start tw-flex-wrap">-->
    <!--                        <img class="tw-w-2/5 tw-rounded tw-shadow-sm animation-float-left tw-self-center"-->
    <!--                            src="<?php echo e(asset('frontend/assets/images/image-06.jpeg')); ?>" alt="">-->
    <!--                        <img class="tw-w-1/2 tw-rounded tw-shadow-sm animation-float-bottom tw-self-center"-->
    <!--                            src="<?php echo e(asset('frontend/assets/images/image-04.jpeg')); ?>" alt="">-->
    <!--                        <img class="tw-w-1/2 tw-rounded tw-shadow-sm animation-float-top tw-self-center"-->
    <!--                            src="<?php echo e(asset('frontend/assets/images/image-05.jpeg')); ?>" alt="">-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--</section>-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend')); ?>/plugins/fontawesome-free/css/all.min.css">
    <?php if (isset($component)) { $__componentOriginalc55f239e5bf30e5997dd7869a18fb76b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc55f239e5bf30e5997dd7869a18fb76b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.map.leaflet.autocomplete_links','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('map.leaflet.autocomplete_links'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc55f239e5bf30e5997dd7869a18fb76b)): ?>
<?php $attributes = $__attributesOriginalc55f239e5bf30e5997dd7869a18fb76b; ?>
<?php unset($__attributesOriginalc55f239e5bf30e5997dd7869a18fb76b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc55f239e5bf30e5997dd7869a18fb76b)): ?>
<?php $component = $__componentOriginalc55f239e5bf30e5997dd7869a18fb76b; ?>
<?php unset($__componentOriginalc55f239e5bf30e5997dd7869a18fb76b); ?>
<?php endif; ?>
    <?php echo $__env->make('map::links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style>
        .hero-section-3 {
            padding: 100px 0px;
            background-image: url('<?php echo e(asset('frontend/assets/images/hero-bg-3.jpeg')); ?>');
            background-repeat: no-repeat;
            background-size: cover;
            position: relative;
        }

        .hero-section-3::after {
            background-color: black;
            content: "";
            height: 100%;
            left: 0;
            opacity: .5;
            position: absolute;
            top: 0;
            width: 100%;
            z-index: 1;
        }

        span.select2-container--default .select2-selection--single {
            border: none !important;
        }

        span.select2-selection.select2-selection--single {
            outline: none;
        }

        .marginleft {
            margin-left: 10px !important;
        }

        .category-slider .slick-slide {
            margin: 0px 8px;
        }

        .category-slider .slick-dots {
            bottom: -32px;
        }

        .category-slider .slick-dots li {
            display: inline-flex;
            justify-content: center;
            align-items: center;
            margin: 0px;
        }

        .category-slider .slick-dots li button {
            background: rgba(255, 255, 255, 0.5);
            border-radius: 50%;
            width: 10px;
            height: 10px;
        }

        .category-slider .slick-dots li.slick-active button {
            background: rgba(255, 255, 255, 1);
            width: 12px;
            height: 12px;
        }

        .category-slider .slick-dots li button::before {
            display: none;
        }

        body:has(.hero-section-2) .n-header--bottom {
            box-shadow: none; !important;
        }
    </style>
    <style>
        .brand-img-size {
            max-width: 100% !important;
            height: auto !important;
            max-width: 250px !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $('.category-slider').slick({
            dots: true,
            arrows: false,
            infinite: true,
            autoplay: true,
            speed: 300,
            slidesToShow: 4,
            slidesToScroll: 1,
            responsive: [{
                    breakpoint: 1024,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1,
                        infinite: true,
                        dots: true
                    }
                },
                {
                    breakpoint: 600,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 480,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1
                    }
                }
            ]
        });
    </script>

    <script>
        $(document).ready(function () {
            $('#district_id').on('change', function () {
                var districtId = $(this).val();

                if (districtId) {
                    $.ajax({
                        url: '<?php echo e(route('get-upazilas', ':district_id')); ?>'.replace(':district_id', districtId),
                        type: 'GET',
                        dataType: 'json',
                        success: function (data) {
                            $('#upazila_id').empty().append('<option value="">Select Upazila</option>');
                            $.each(data, function (key, value) {
                                $('#upazila_id').append('<option value="' + value.id + '">' + value.name + '</option>');
                            });
                        }
                    });
                } else {
                    $('#upazila_id').empty().append('<option value="">Select Upazila</option>');
                }
            });
        });
    </script>
    <script>
        $(document).ready(function(){
            $('.testimonail_active').slick({
                slidesToShow: 2,
                slidesToScroll: 1,
                autoplay: true,
                autoplaySpeed: 3000,
                prevArrow: $('.slickprev2'),
                nextArrow: $('.slicknext2'),
                dots: true,
                responsive: [
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 1,
                        }
                    }
                ]
            });
        });
    </script>
    <script>
    const enToBnDigits = {
        '0': '০', '1': '১', '2': '২', '3': '৩', '4': '৪',
        '5': '৫', '6': '৬', '7': '৭', '8': '৮', '9': '৯'
    };

    function toBanglaNumber(number) {
        return number.toString().replace(/\d/g, digit => enToBnDigits[digit]);
    }

    function formatBDNumber(numStr) {
        let x = numStr.replace(/,/g, '');
        if (x.length <= 3) return x;
        let last3 = x.slice(-3);
        let other = x.slice(0, -3);
        other = other.replace(/\B(?=(\d{2})+(?!\d))/g, ",");
        return other + "," + last3;
    }

    function convertKToHazar(value) {
        // Convert like 20k → ২০০০০ → ২০ হাজার
        if (value.toLowerCase().endsWith('k')) {
            const num = parseFloat(value.toLowerCase().replace('k', '')) * 1000;
            const thousand = (num / 1000).toString();
            return `${toBanglaNumber(thousand)} হাজার`;
        } else {
            const formatted = formatBDNumber(value.replace(/[^0-9]/g, ''));
            return toBanglaNumber(formatted);
        }
    }

    function convertSalaryToBangla() {
        document.querySelectorAll('.salary-section').forEach(el => {
            let text = el.innerText.trim();
            const isRange = text.includes('-');
            const currency = '<?php echo e(currentCurrencyCode()); ?>';

            if (isRange) {
                const parts = text.replace(currency, '').split('-').map(p => p.trim());
                const min = convertKToHazar(parts[0]);
                const max = convertKToHazar(parts[1]);
                el.innerText = `${min} - ${max} ${currency}`;
            } else {
                const amount = convertKToHazar(text.replace(currency, '').trim());
                el.innerText = `${amount} ${currency}`;
            }
        });
    }

    document.addEventListener('DOMContentLoaded', convertSalaryToBangla);
</script>


<?php $__env->stopSection(); ?> 
<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u470884714/domains/qjobsbd.com/public_html/resources/views/frontend/pages/index-3.blade.php ENDPATH**/ ?>